% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Motif2Site.R
\name{compareMotifs2UserProvidedRegions}
\alias{compareMotifs2UserProvidedRegions}
\title{Compare a set of motifs to a user provided regions set}
\usage{
compareMotifs2UserProvidedRegions(
  motifs,
  mismatchNumbers,
  genome,
  genomeBuild,
  DB = "UCSC",
  givenRegion,
  mainCHRs = TRUE
)
}
\arguments{
\item{motifs}{a vector of motif characters in nucleotide IUPAC format}

\item{mismatchNumbers}{a vector Number of mismatches allowed to match with
motifs}

\item{genome}{The genome name such as "Hsapiens", "Mmusculus",
"Dmelanogaster"}

\item{genomeBuild}{The genome build such as "hg38", "hg19", "mm10", "dm3"}

\item{DB}{The database of genome build. default: "UCSC"}

\item{givenRegion}{granges of user provided binding regions}

\item{mainCHRs}{If true only the major chromosome are considered, if FALSE
Random, Uncharacterised, and Mithocondrial chromosomes are also considered}
}
\value{
A dataframe which includes precision recall values for each motif
}
\description{
This function gets user provided motifs and related mismatch
numbers, it detects motifs and compare them with a user provided region.

It returns this comparison to given user binding regions in
terms of precision/recall.

The genome and build information should be provided and relevant
 BS genomes packages such as BSgenome.Mmusculus.UCSC.mm10 or
  BSgenome.Hsapiens.UCSC.hg38 must
 be installed for the used genome and builds.
}
\examples{

# Artificial example in Yeast
# install BSgenome.Scerevisiae.UCSC.sacCer3 prior to run this code
 yeastExampleFile=system.file("extdata", "YeastSampleMotif.bed",
                                package="Motif2Site")
YeastRegionsChIPseq <- Bed2Granges(yeastExampleFile)
SequenceComparison <- compareMotifs2UserProvidedRegions(
   givenRegion=YeastRegionsChIPseq,
   motifs=c("TGATTSCAGGANT", "TGATTCCAGGANT", "TGATWSCAGGANT"),
   mismatchNumbers=c(1,0,2),
   genome="Scerevisiae",
   genomeBuild="sacCer3"
   )
SequenceComparison


}
\seealso{
\code{\link{compareBedFiless2UserProvidedRegions}}
}
