% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Motif2Site.R
\name{decomposeBindingSignal}
\alias{decomposeBindingSignal}
\title{Decompose binding signal among accepted motifs}
\usage{
decomposeBindingSignal(
  windowSize,
  replicateNumber,
  acceptedRegionsOutputFile = "BindingRegions",
  acceptedMotifsOutputFile = "BindingMotifsTable",
  currentDir
)
}
\arguments{
\item{windowSize}{Window size around binding site. The total region would be
2*windowSize+1}

\item{replicateNumber}{experiment replicate number}

\item{acceptedRegionsOutputFile}{File name contains binding regions
coordinates and related motifs}

\item{acceptedMotifsOutputFile}{File name contains motifs coordinates and
related information, Pvalue, FE, etc}

\item{currentDir}{Directory for I/O operations}
}
\value{
motifStatistics Ratio of accepted motifs, rejected motifs due to
 skewnewss, and rejected motifs after decomposition
}
\description{
Gets motif locations and related short reads and select the
 motifs which are non-skewed: abs(skewness) < 0.3 and more short reads binds
  closer to site, and show strong binding after decomposition.

Decomposition is performed by using mixtools normalmixEM command
 fixing mu as motif locations.
}
