% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MsBackendRawFileReader.R
\docType{class}
\name{MsBackendRawFileReader-class}
\alias{MsBackendRawFileReader-class}
\title{RawFileReader-based backend}
\description{
The `MsBackendRawFileReader` inherits all slots and methods from the base
`MsBackendDataFrame` (in-memory) backend. It overrides the base `mz` and
`intensity` methods as well as `peaksData` to read the respective data from
the original raw data files.

The validator function has to ensure that the files exist and that required
column names are present.

The `backendInitialize` method reads the header data from the raw files and
hence fills the `spectraData` slot.
}
\examples{
beRaw <- Spectra::backendInitialize(MsBackendRawFileReader::MsBackendRawFileReader(),
  files = rawrr::sampleFilePath())
beRaw
Spectra::msLevel(beRaw)
}
\author{
Christian Panse (2019-2021)
}
