% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MsExperimentFiles.R, R/existMsExperimentFiles.R
\name{MsExperimentFiles}
\alias{MsExperimentFiles}
\alias{MsExperimentFiles-class}
\alias{show,MsExperimentFiles-method}
\alias{existMsExperimentFiles}
\title{A class to store experiment files}
\usage{
MsExperimentFiles(..., metadata = list())

\S4method{show}{MsExperimentFiles}(object)

existMsExperimentFiles(object)
}
\arguments{
\item{...}{Either a named list or a set of named vectors. All
elements are coerced to characters.}

\item{metadata}{\code{list()} holding arbitrary R objects as
annotations.}

\item{object}{The \code{existMsExperimentFiles()} function works with
either an instance of \code{MsExperimentFiles} or \code{MsExperiment}.}
}
\value{
\code{MsExperimentFiles} returns an instance of \code{MsExperimentFiles}.
}
\description{
The \code{MsExperimentFiles} class stores files that are part of a mass
spectrometry experiment. The objects are created with the
\code{MsExperimentFiles()} function.

The files encoded in a \code{MsExperimentFiles} instance don't need to
exist on the current filesystem - sometimes, these might be created
in anticipation of their creation. The \code{existMsExperimentFiles()}
function can be used to verify which ones currently exist: it
returns a list of logicals (formally an instance of
\code{\link[IRanges:AtomicList-class]{IRanges::LogicalList()}} of lenghts equal to the
\code{MsExperimentFiles} used as input.
}
\examples{
fls <- MsExperimentFiles(mzmls = c("/path/to/f1.mzML", "/path/to/f2.mzML"),
                         mzids = "/another/path/to/id1.mzid",
                         fasta = "file.fas")
fls

## A new MsExperimentFiles containing mzML or mzid files
fls[1]
fls["mzids"]

## The actual file names
fls[[1]]
fls[[2]]
fls[["fasta"]]

## None of the files used in this example actually exist
existMsExperimentFiles(fls)
}
\author{
Laurent Gatto
}
