% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DATAplotExpressionGenes.R
\name{DATAplotExpressionGenes}
\alias{DATAplotExpressionGenes}
\title{Plot expression of a subset of genes.}
\usage{
DATAplotExpressionGenes(
  SEresNorm,
  Vector.row.gene,
  DATAnorm = TRUE,
  Color.Group = NULL,
  Plot.Expression = TRUE,
  path.result = NULL,
  Name.folder.profile = NULL
)
}
\arguments{
\item{SEresNorm}{Results of the function
\code{\link[=DATAnormalization]{DATAnormalization()}}.}

\item{Vector.row.gene}{Vector of non negative integers indicating
the rows of the genes to be plotted.}

\item{DATAnorm}{\code{TRUE} or \code{FALSE}. \code{TRUE} by default.
\code{TRUE} means the function plots gene normalized expression profiles.
\code{FALSE} means the function plots gene raw expression profiles.}

\item{Color.Group}{\code{NULL} or a data.frame with \eqn{N_{bc}} rows and
two columns where \eqn{N_{bc}} is the number of biological conditions.
If \code{Color.Group} is a data.frame, the first column must contain
the name of each biological condition and the second column must contain
the colors associated to each biological condition.
If \code{Color.Group=NULL}, the function will automatically attribute
a color for each biological condition.
If samples belong to different time points only,
\code{Color.Group} will not be used. \code{NULL} by default.}

\item{Plot.Expression}{\code{TRUE} or \code{FALSE}. \code{TRUE} by default.
If \code{TRUE}, the graph will be plotted.
Otherwise no graph will be plotted.}

\item{path.result}{Character or \code{NULL}. \code{NULL} by default.
Path to save all results.
If \code{path.result} contains a sub folder entitled
"1_UnsupervisedAnalysis_\code{Name.folder.profile}" and a sub sub folder,
"1-5_ProfileExpression_\code{Name.folder.profile}"
all results will be saved in the sub folder
"1_UnsupervisedAnalysis_\code{Name.folder.profile}/
1-5_ProfileExpression_\code{Name.folder.profile}".
Otherwise, a sub folder entitled
"1_UnsupervisedAnalysis_\code{Name.folder.profile}" and/or a sub sub folder
"1-5_ProfileExpression_\code{Name.folder.profile}"
will be created in \code{path.result} and all results will be saved in
"1_UnsupervisedAnalysis_\code{Name.folder.profile}/
1-5_ProfileExpression_\code{Name.folder.profile}".
If NULL, the results will not be saved in a folder. NULL as default.}

\item{Name.folder.profile}{Character or \code{NULL}. \code{NULL} by default.
If \code{Name.folder.profile} is a character, the folder and
sub folder names which will contain the PCA graphs will respectively be
"1_UnsupervisedAnalysis_\code{Name.folder.profile}" and
"1-5_ProfileExpression_\code{Name.folder.profile}".
Otherwise, the folder and sub folder names will respectively be
"1_UnsupervisedAnalysis" and "1-5_ProfileExpression".}
}
\value{
The function returns the same SummarizedExperiment class object
\code{SEresNorm} with the a graph for each gene
(depending on the experimental design)
selected with the input \code{Vector.row.gene}
(saved in the metadata \code{Results[[1]][[5]]} of \code{SEresNorm})
\itemize{
\item In the case where samples belong to different time points only :
the evolution of the expression of each replicate across time and
the evolution of the mean and the standard deviation of the expression
across time.
\item In the case where samples belong to different biological conditions only:
a violin plot
(see \code{\link[ggplot2:geom_violin]{ggplot2::geom_violin()}}),
and error bars (standard deviation)
(see \code{\link[ggplot2:geom_linerange]{ggplot2::geom_errorbar()}})
for each biological condition.
\item In the case where samples belong to different time points and different
biological conditions : the evolution of the expression of each replicate
across time and the evolution of the mean and the standard deviation
of the expression across time for each biological condition.
}

The function plots the different graph if
\code{Plot.Expression=TRUE}.
}
\description{
The function allows to plot gene expression profiles
according to time and/or biological conditions.
}
\details{
All results are built from the results of our function
\code{\link[=DATAnormalization]{DATAnormalization()}}.
}
\examples{
## Simulation raw counts
resSIMcount <- RawCountsSimulation(Nb.Group=2, Nb.Time=3, Nb.per.GT=4,
                                   Nb.Gene=10)
## Preprocessing step
resDATAprepSE <- DATAprepSE(RawCounts=resSIMcount$Sim.dat,
                            Column.gene=1,
                            Group.position=1,
                            Time.position=2,
                            Individual.position=3)
## Normalization
resNorm <- DATAnormalization(SEres=resDATAprepSE,
                             Normalization="rle",
                             Plot.Boxplot=FALSE,
                             Colored.By.Factors=FALSE)
##-----------------------------------------------------------------------##
resEVOgenes <- DATAplotExpressionGenes(SEresNorm=resNorm,
                                       Vector.row.gene=c(1,3),
                                       DATAnorm=TRUE,
                                       Color.Group=NULL,
                                       Plot.Expression=TRUE,
                                       path.result=NULL,
                                       Name.folder.profile=NULL)
}
\seealso{
The function calls our R function
\code{\link[=DATAnormalization]{DATAnormalization()}}
fisrt, then
\code{\link[=DATAplotExpression1Gene]{DATAplotExpression1Gene()}}
for each selected genes with \code{Vector.row.gene}.
}
