% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_vcf.R
\name{download_vcf}
\alias{download_vcf}
\title{Download VCF file and its index file from Open GWAS}
\usage{
download_vcf(
  vcf_url,
  vcf_dir = tempdir(),
  vcf_download = TRUE,
  download_method = "download.file",
  force_new = FALSE,
  quiet = FALSE,
  timeout = 10 * 60,
  nThread = 1
)
}
\arguments{
\item{vcf_url}{Remote URL to VCF file.}

\item{vcf_dir}{Where to download the original VCF from Open GWAS.
\emph{WARNING:} This is set to \code{tempdir()} by default.
This means the raw (pre-formatted) VCFs be deleted upon ending the R session.
Change this to keep the raw VCF file on disk
(e.g. \code{vcf_dir="./raw_vcf"}).}

\item{vcf_download}{Download the original VCF from Open GWAS.}

\item{download_method}{\code{"axel"} (multi-threaded) or
\code{"download.file"} (single-threaded) .}

\item{force_new}{Overwrite a previously downloaded VCF
with the same path name.}

\item{quiet}{Run quietly.}

\item{timeout}{How many seconds before giving up on download.
Passed to \code{download.file}. Default: \code{10*60} (10min).}

\item{nThread}{Number of threads to parallelize over.}
}
\value{
List containing the paths to the downloaded VCF and its index file.
}
\description{
Ideally, we would use \href{https://github.com/MRCIEU/gwasvcf}{gwasvcf}
instead but it hasn't been made available on CRAN or Bioconductor yet,
so we can't include it as a dep.
}
\examples{
#only run the examples if user has internet access:
if(try(is.character(getURL("www.google.com")))==TRUE){
vcf_url <- "https://gwas.mrcieu.ac.uk/files/ieu-a-298/ieu-a-298.vcf.gz"
out_paths <- download_vcf(vcf_url = vcf_url)
}
}
