% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/newFit.R
\name{optimization}
\alias{optimization}
\title{Optimize the parameters of a Negative Binomial regression model}
\usage{
optimization(
  Y,
  cluster,
  children,
  model,
  max_iter,
  stop_epsilon,
  n_gene_disp,
  n_cell_par,
  n_gene_par,
  commondispersion,
  verbose
)
}
\arguments{
\item{cluster}{The PSOCK cluster}

\item{children}{Number of child process}

\item{model}{newmodel item}

\item{max_iter}{maximum number of iterations}

\item{stop_epsilon}{stopping criterion, when the relative gain in
likelihood is below epsilon}

\item{n_gene_disp}{number of genes used in mini-batch dispersion estimation
approach(default NULL > all genes are used)}

\item{n_cell_par}{number of cells used in mini-batch cell's related
parameters estimation approach(default NULL > all cells are used)}

\item{n_gene_par}{number of genes used in mini-batch gene's related
parameters estimation approach(default NULL > all genes are used)}

\item{commondispersion}{Whether or not a single dispersion for all features
is estimated (default TRUE).}

\item{verbose}{print information (default FALSE)}
}
\value{
An object of class newmodel similar to the one given as argument
  with modified parameters alpha, beta, gamma, W.
}
\description{
The parameters of the model given as argument are optimized by penalized
maximum likelihood on the count matrix given as argument.
}
\keyword{internal}
