% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NormalyzerDataset.R
\name{NormalyzerDataset}
\alias{NormalyzerDataset}
\title{Represents raw input data together with basic annotation information}
\usage{
NormalyzerDataset(
  jobName,
  designMatrix,
  rawData,
  annotationData,
  sampleNameCol,
  groupNameCol,
  tinyRunThres = 50,
  quiet = FALSE
)

NormalyzerDataset(
  jobName,
  designMatrix,
  rawData,
  annotationData,
  sampleNameCol,
  groupNameCol,
  tinyRunThres = 50,
  quiet = FALSE
)
}
\arguments{
\item{jobName}{Name of the NormalyzerDE processing run}

\item{designMatrix}{Matrix containing sample conditions}

\item{rawData}{Matrix containing raw input data}

\item{annotationData}{Matrix containing annotation information for each
input feature. Is expected to contain the same number of rows as the data
but can contain any number of features}

\item{sampleNameCol}{Name of column in design matrix containing sample
information}

\item{groupNameCol}{Name of column in design matrix containing condition
information}

\item{tinyRunThres}{If fewer features than this is present in the input
a limited run will be performed to avoid some steps requiring a more
extensive number of features.}

\item{quiet}{If set to TRUE no information messages will be printed}
}
\value{
nds Generated NormalyzerDataset instance
}
\description{
Takes a job name, a data matrix, a design matrix as well as specification
of the group and sample columns in the design matrix. Provides the
basic representation of a dataset in the NormalyzerDE normalization part.
}
\section{Slots}{

\describe{
\item{\code{jobName}}{Name of the job represented by the dataset.}

\item{\code{rawData}}{Matrix with raw values.}

\item{\code{sampleNameCol}}{Name column for sample.}

\item{\code{groupNameCol}}{Name column for groups.}

\item{\code{designMatrix}}{Data frame containing design.}

\item{\code{sampleNames}}{Vector containing sample names.}

\item{\code{filterrawdata}}{Reduced raw data matrix where low abundance rows are 
removed}

\item{\code{sampleReplicateGroups}}{Vector with sample replicate information}

\item{\code{samplesGroupsWithReplicates}}{Vector with replicated sample replicate information}

\item{\code{annotationValues}}{Annotation part of original dataframe.}

\item{\code{retentionTimes}}{Vector of retention time values.}

\item{\code{singleReplicateRun}}{Conditional whether run is single replicate.}
}}

\keyword{internal}
