% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NormalyzerEvaluationResults.R
\name{NormalyzerEvaluationResults}
\alias{NormalyzerEvaluationResults}
\title{Representation of evaluation results by calculating performance measures
for an an NormalyzerResults instance}
\usage{
NormalyzerEvaluationResults(nr)

NormalyzerEvaluationResults(nr)
}
\arguments{
\item{nr}{NormalyzerResults object}
}
\value{
nds Generated NormalyzerEvaluationResults instance
}
\description{
Contains the resulting information from the processing which subsequently
can be used to generate the quality assessment report.
}
\section{Slots}{

\describe{
\item{\code{avgcvmem}}{Average coefficient of variance per method}

\item{\code{avgcvmempdiff}}{Percentage difference of mean coefficient of variance
compared to log2-transformed data}

\item{\code{featureCVPerMethod}}{CV calculated per feature and normalization method.}

\item{\code{avgmadmem}}{Average median absolute deviation}

\item{\code{avgmadmempdiff}}{Percentage difference of median absolute deviation
compared to log2-transformed data}

\item{\code{avgvarmem}}{Average variance per method}

\item{\code{avgvarmempdiff}}{Percentage difference of mean variance compared
to log2-transformed data}

\item{\code{lowVarFeaturesCVs}}{List of 5% least variable entries based on ANOVA
for log2-transformed data}

\item{\code{lowVarFeaturesCVsPercDiff}}{Coefficient of variance for least variable
entries}

\item{\code{anovaP}}{ANOVA calculated p-values}

\item{\code{repCorPear}}{Within group Pearson correlations}

\item{\code{repCorSpear}}{Within group Spearman correlations}
}}

\examples{
data(example_summarized_experiment)
normObj <- getVerifiedNormalyzerObject("job_name", example_summarized_experiment)
normResults <- normMethods(normObj)
normEval <- NormalyzerEvaluationResults(normResults)
}
