% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NormalyzerStatistics.R
\name{calculateContrasts}
\alias{calculateContrasts}
\alias{calculateContrasts,NormalyzerStatistics-method}
\title{Performs statistical comparisons between the supplied conditions.
It uses the design matrix and data matrix in the supplied 
NormalyzerStatistics object. A column is supplied specifying which of the
columns in the design matrix that is used for deciding the sample groups.
The comparisons vector specifies which pairwise comparisons between
condition levels that are to be calculated.}
\usage{
calculateContrasts(
  nst,
  comparisons,
  condCol,
  batchCol = NULL,
  splitter = "-",
  type = "limma",
  leastRepCount = 1
)

\S4method{calculateContrasts}{NormalyzerStatistics}(
  nst,
  comparisons,
  condCol,
  batchCol = NULL,
  splitter = "-",
  type = "limma",
  leastRepCount = 1
)
}
\arguments{
\item{nst}{Results evaluation object.}

\item{comparisons}{String with comparisons for contrasts.}

\item{condCol}{Column name in design matrix containing condition information.}

\item{batchCol}{Column name in design matrix containing batch information.}

\item{splitter}{Character dividing contrast conditions.}

\item{type}{Type of statistical test (Limma or welch).}

\item{leastRepCount}{Least replicates in each group to be retained for 
contrast calculations}
}
\value{
nst Statistics object with statistical measures calculated
}
\description{
Optionally, a batch column can be specified allowing compensation for
covariate variation in the statistical model. This is only compatible
with a Limma-based statistical analysis.
}
\examples{
data(example_stat_summarized_experiment)
nst <- NormalyzerStatistics(example_stat_summarized_experiment)
results <- calculateContrasts(nst, c("1-2", "2-3"), "group")
resultsBatch <- calculateContrasts(nst, c("1-2", "2-3"), "group", batchCol="batch")
}
