% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyzeResults.R
\name{calculateSummarizedCorrelationVector}
\alias{calculateSummarizedCorrelationVector}
\title{Calculates correlation values between replicates for each condition matrix.
Finally returns a matrix containing the results for all dataset}
\usage{
calculateSummarizedCorrelationVector(
  methodlist,
  allReplicateGroups,
  sampleGroupsWithReplicates,
  corrType
)
}
\arguments{
\item{methodlist}{List containing normalized matrices for each normalization
method}

\item{allReplicateGroups}{Vector with condition groups matching the columns
found in the normalization methods}

\item{sampleGroupsWithReplicates}{Unique vector with condition groups
present in two or more samples}

\item{corrType}{Type of correlation (Pearson or Spearman)}
}
\value{
avgCorSum Matrix with column corresponding to normalization
approaches and rows corresponding to replicate group
}
\description{
Calculates correlation values between replicates for each condition matrix.
Finally returns a matrix containing the results for all dataset
}
\keyword{internal}
