% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculateStatistics.R
\name{generateAnnotatedMatrix}
\alias{generateAnnotatedMatrix}
\title{Generate an annotated data frame from statistics object}
\usage{
generateAnnotatedMatrix(nst, prefixSep = "_", compLabels = NULL)
}
\arguments{
\item{nst}{NormalyzerDE statistics object.}

\item{prefixSep}{Character string for separating the prefix names from the statistics suffix}

\item{compLabels}{Vector containing strings to use as prefix for statistical comparisons}
}
\value{
outDf Annotated statistics matrix
}
\description{
Extracts key values (p-value, adjusted p-value, log2-fold change and
average expression values) from an NormalyzerStatistics instance
and appends these to the annotation- and data-matrices
}
\examples{
data(example_stat_summarized_experiment)
statObj <- NormalyzerStatistics(example_stat_summarized_experiment)
statObj <- calculateContrasts(statObj, comparisons=c("1-2", "2-3"), condCol="group", type="limma")
annotDf <- generateAnnotatedMatrix(statObj)
}
