% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inputVerification.R
\name{getVerifiedNormalyzerObject}
\alias{getVerifiedNormalyzerObject}
\title{Verify that input data is in correct format, and if so, return a generated
 NormalyzerDE data object from that input data}
\usage{
getVerifiedNormalyzerObject(
  jobName,
  summarizedExp,
  threshold = 15,
  omitSamples = FALSE,
  requireReplicates = TRUE,
  quiet = FALSE,
  noLogTransform = FALSE,
  tinyRunThres = 50
)
}
\arguments{
\item{jobName}{Name of ongoing run.}

\item{summarizedExp}{Summarized experiment input object}

\item{threshold}{Minimum number of features.}

\item{omitSamples}{Automatically omit invalid samples from analysis.}

\item{requireReplicates}{Require there to be at least to samples per
condition}

\item{quiet}{Don't print output messages during processing}

\item{noLogTransform}{Don't log-transform the provided data}

\item{tinyRunThres}{If less features in run, a limited run is performed}
}
\value{
Normalyzer data object representing verified input data.
}
\description{
This function performs a number of checks on the input data and provides
informative error messages if the data isn't fulfilling the required format.
Checks include verifying that the design matrix matches to the data matrix,
that the data matrix contains valid numbers and that samples have enough
values for analysis
}
\examples{
data(example_summarized_experiment)
normObj <- getVerifiedNormalyzerObject("job_name", example_summarized_experiment)
}
