% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\docType{package}
\name{OGRE-package}
\alias{OGRE-package}
\title{OGRE package to calculate, analyze and visiualize overlap between annotated
genomic region datasets}
\description{
OGRE calculates overlap between user defined annotated genomic region
datasets. Any regions can be supplied such as public annotations (genes),
genetic variation (SNPs, mutations), regulatory elements (TFBS, promoters,
CpG islands) and basically all  types of NGS output from sequencing
experiments. After overlap calculation, key numbers help analyse the extend
of overlaps which can also be visualized at a genomic level.
}
\details{
The main functions are:

\code{\link{OGREDataSetFromDir}} - build an OGRE dataset from a user
defined directory with GRanges annotation files.
\itemize{
\item \code{\link{loadAnnotations}} - Load dataset files containing genomic
regions annotation information from hard drive
}

\code{\link{OGREDataSet}} - build an empty OGRE dataset to flexibly add
datasets from other sources like AnnotationHub or custom GRanges objects.
\itemize{
\item \code{\link{addDataSetFromHub}} - adds datasets from AnnotationHub
\item \code{\link{addGRanges}} - adds user defined GenomicRanges datasets
}

\code{\link{fOverlaps}} - Finds all overlaps between query and subject
datasets\cr
\code{\link{sumPlot}} - calculates key numbers, tables and plots\cr
\code{\link{gvizPlot}} - generates a genomic plot around query elements with
overlapping subject hits.

For additional information, see the package vignette, by typing
\code{vignette("OGRE")}. Software-related questions or issues can be posted
to the Bioconductor Support Site:

\url{https://support.bioconductor.org}

or on github:

\url{https://https://github.com/svenbioinf/OGRE}\cr
}
\author{
Sven Berres, Jörg Gromoll, Marius Wöste, Sarah Sandmann, Sandra
Laurentino
}
\keyword{package}
