\name{p.int2}
\alias{p.int2} 
\title{Calculates significance of  intensity-dependent bias}	
\description{This function assesses the significance of intensity-dependent bias.  This is 
achieved by comparing the observed average values of logged fold-changes within an intensity neighbourhood
with an empirical distribution generated by permutation tests. The significance is given
by (adjusted) p-values.}
\usage{p.int2(object,delta=50,N=-1,av="median",p.adjust.method="none")}
\arguments{\item{object}{object of class marrayRaw or marrayNorm}
           \item{delta}{integer determining the size of the neighbourhood (\code{2 * delta+1}).}
           \item{N}{number of random samples (of size \code{2 * delta+1}) used for the 
                 generation of empirical distribution. If N is negative, 
                 the number of samples 100 times the length of \code{A}.  }
           \item{av}{averaging of \code{M} within neighbourhood by \emph{mean} or \emph{median} (default)}
           \item{p.adjust.method}{method for adjusting p-values due to multiple testing regime. The available
                 methods are \dQuote{none}, \dQuote{bonferroni},  \dQuote{holm}, \dQuote{hochberg},
                 \dQuote{hommel} and \dQuote{fdr}.  See also \code{\link{p.adjust}}} }



\details{This function \code{p.int2} is basically the same as \code{p.int} except for 
differences  in their in- and output format. For the details about the functionality, see \code{\link{p.int}}.  }
\note{This function will be merged with \code{p.int} in future versions.}

\author{Matthias E. Futschik (\url{http://itb.biologie.hu-berlin.de/~futschik})}
\seealso{\code{\link{p.int}},\code{\link{fdr.int2}}, \code{\link{sigint.plot2}}, \code{\link{p.adjust}}}
\examples{

# To run these examples, "un-comment" them!
#
# LOADING DATA NOT-NORMALISED
# data(sw)
# CALCULATION OF SIGNIFICANCE OF SPOT NEIGHBOURHOODS
#  For this illustration, N was chosen rather small. For "real" analysis, it should be larger.
# P <- p.int2(sw,delta=50,N=10000,av="median",p.adjust.method="none")
# VISUALISATION OF RESULTS
# sigint.plot2(sw[,1],Sp=P$Pp[[1]],Sn=P$Pn[[1]],c(-5,-5)) # array 1
# sigint.plot2(sw[,3],Sp=P$Pp[[3]],Sn=P$Pn[[3]],c(-5,-5)) # array 3


}
\keyword{nonparametric}
\keyword{univar}
\keyword{htest}




