% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SummarizedExperiment_helpers.R
\name{countTable_regions}
\alias{countTable_regions}
\title{Make a list of count matrices from experiment}
\usage{
countTable_regions(
  df,
  out.dir = libFolder(df),
  longestPerGene = FALSE,
  geneOrTxNames = "tx",
  regions = c("mrna", "leaders", "cds", "trailers"),
  type = "count",
  lib.type = "ofst",
  weight = "score",
  rel.dir = "QC_STATS",
  forceRemake = FALSE,
  library.names = bamVarName(df),
  format = "qs",
  path_prefix = if (!is.null(out.dir)) {
     pasteDir(file.path(out.dir, rel.dir,
    "countTable_"))
 } else {
     NULL
 },
  libraries = outputLibs(df, chrStyle = seqinfo(df), paths = filepath(df, lib.type), type
    = lib.type, force = FALSE, library.names = library.names, BPPARAM =
    BiocParallel::SerialParam()),
  BPPARAM = bpparam()
)
}
\arguments{
\item{df}{an ORFik \code{\link{experiment}}}

\item{out.dir}{character, output directory, default:
\code{resFolder(df)}.
Will make a folder within this called "QC_STATS" with all results in this directory.
Warning: If you assign not default path, you will have a hazzle to load files later.
Much easier to load count tables, statistics, ++ later with default. Update
resFolder of df instead if needed.}

\item{longestPerGene}{a logical (default FALSE), if FALSE all transcript
isoforms per gene. Ignored if "region" is not a character of either:
"mRNA","tx", "cds", "leaders" or "trailers".}

\item{geneOrTxNames}{a character vector (default "tx"), should row names
keep trancript names ("tx") or change to gene names ("gene")}

\item{regions}{a character vector, default:
 c("mrna", "leaders", "cds", "trailers"), make raw count matrices
of whole regions specified. Can also be a custom GRangesList of
for example uORFs or a subset of cds etc.}

\item{type}{default: "count" (raw counts matrix), alternative is "fpkm",
"log2fpkm" or "log10fpkm"}

\item{lib.type}{a character(default: "default"), load files in experiment
or some precomputed variant, either "ofst", "pshifted" or "cov"
These are made with ORFik:::convertLibs() or shiftFootprintsByExperiment().
Can also be custom user made folders inside the experiments bam folder.
Format "cov" (i.e. covRle format) is by far the fastest to use if existing.}

\item{weight}{numeric or character, a column to score overlaps by. Default "score",
will check for a metacolumn called "score" in libraries. If not found,
will not use weights.}

\item{rel.dir}{relative output directory for out.dir, default:
"QC_STATS". For pshifted, write "pshifted".}

\item{forceRemake}{logical, default FALSE. If TRUE, will not look for existing file count table files.}

\item{library.names}{character, default: bamVarName(df). Names to load
libraries as to environment and names to display in plots.}

\item{format}{character, default "qs", alternative: "rds". Which format to save summarizedExperiment.}

\item{path_prefix}{the prefix names of tables, default:\cr
\code{if (!is.null(out.dir) {pasteDir(file.path(out.dir, rel.dir, "countTable_"))} else {NULL}}\cr
i.e. directory + countTable_ or NULL if out.dir is NULL.}

\item{libraries}{The call to output libraries, the input is not used! Default:
\code{outputLibs(df, chrStyle = seqinfo(df), paths = filepath(df, lib.type),
 type = lib.type, force = force, library.names = library.names, BPPARAM = BPPARAM)}}

\item{BPPARAM}{how many cores/threads to use? default: bpparam()}
}
\value{
a list of data.table, 1 data.table per region. The regions
will be the names the list elements.
}
\description{
By default will make count tables over mRNA, leaders, cds and trailers for
all libraries in experiment. Saved as "qs" or "rds" format files.
}
\examples{
##Make experiment
df <- ORFik.template.experiment()
## Create count tables for all default regions
countTable_regions(df, NULL)
## Pshifted reads (first create pshiftead libs)
# countTable_regions(df, lib.type = "pshifted", rel.dir = "pshifted")
}
\seealso{
Other countTable: 
\code{\link{countTable}()}
}
\concept{countTable}
