% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SRA_helper.R
\name{extract_run_id}
\alias{extract_run_id}
\title{Extract SRR/ERR/DRR run IDs from string}
\usage{
extract_run_id(
  x,
  search = "(SRR[0-9]+|DRR[0-9]+|ERR[0-9]+)",
  only_valid = FALSE
)
}
\arguments{
\item{x}{character vector to search through.}

\item{search}{the regex search, default: \code{"(SRR[0-9]+|DRR[0-9]+|ERR[0-9]+)"}}

\item{only_valid}{logical, default FALSE. If TRUE, return only the hits.}
}
\value{
a character vector of run accepted run ids according to search,
if only_valid named character vector for which indices are returned
}
\description{
Extract SRR/ERR/DRR run IDs from string
}
\examples{
search <- c("SRR1230123_absdb", "SRR1241204124_asdasd", "asd_ERR1231230213",
 "DRR12412412_asdqwe", "ASDASD_ASDASD", "SRRASDASD")
ORFik:::extract_run_id(search)
ORFik:::extract_run_id(search, only_valid = TRUE)
}
