% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/experiment.R
\name{list.experiments}
\alias{list.experiments}
\title{List current experiment available}
\usage{
list.experiments(
  dir = ORFik::config()["exp"],
  pattern = "*",
  libtypeExclusive = NULL,
  validate = TRUE,
  BPPARAM = if (!validate) {
     BiocParallel::SerialParam()
 } else
    BiocParallel::bpparam()
)
}
\arguments{
\item{dir}{directory for ORFik experiments: default:
ORFik::config()["exp"], which by default is:
"~/Bio_data/ORFik_experiments/"}

\item{pattern}{allowed patterns in experiment file name:
default ("*", all experiments)}

\item{libtypeExclusive}{search for experiments with exclusivly this
libtype, default (NULL, all)}

\item{validate}{logical, default TRUE. Abort if any library files does not exist.
Do not set this to FALSE, unless you know what you are doing!}

\item{BPPARAM}{how many cores/threads to use? Default single thread
if validate is FALSE, else use bpparam.
default: \code{if(!validate){ BiocParallel::SerialParam()} else
 BiocParallel::bpparam()}}
}
\value{
a data.table, 1 row per experiment with columns:\cr
 - experiment (name),\cr
 - organism\cr
 - author \cr
 - libtypes\cr
 - number of samples
}
\description{
Will only search .csv extension, also exclude any experiment
with the word template.
}
\examples{
## Make your experiments
df <- ORFik.template.experiment(TRUE)
df2 <- df[1:6,] # Only first 2 libs
## Save them
# save.experiment(df, "~/Bio_data/ORFik_experiments/exp1.csv")
# save.experiment(df2, "~/Bio_data/ORFik_experiments/exp1_subset.csv")
## List all experiment you have:
## Path above is default path, so no dir argument needed
#list.experiments()
#list.experiments(pattern = "subset")
## For non default directory experiments
#list.experiments(dir = "MY/CUSTOM/PATH)
}
