% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/txdbHelpers.R
\name{loadRegions}
\alias{loadRegions}
\title{Get all regions of transcripts specified to environment}
\usage{
loadRegions(
  txdb,
  parts = c("mrna", "leaders", "cds", "trailers"),
  extension = "",
  names.keep = NULL,
  by = "tx",
  skip.optimized = FALSE,
  envir = .GlobalEnv
)
}
\arguments{
\item{txdb}{a TxDb file, a path to one of:
(.gtf ,.gff, .gff2, .gff2, .db or .sqlite)
or an ORFik experiment}

\item{parts}{the transcript parts you want, default:
c("mrna", "leaders", "cds", "trailers").\cr See ?loadRegion for more info
on this argument.}

\item{extension}{What to add on the name after leader, like: B -> leadersB}

\item{names.keep}{a character vector of subset of names to keep. Example:
loadRegions(txdb, names = "ENST1000005"), will return only that transcript.
Remember if you set by to "gene", then this list must be with gene names.}

\item{by}{a character, default "tx" Either "tx" or "gene". What names to
output region by, the transcript name "tx" or gene names "gene".
NOTE: this is not the same as cdsBy(txdb, by = "gene"), cdsBy would then
only give 1 cds per Gene, loadRegion gives all isoforms, but with gene names.}

\item{skip.optimized}{logical, default FALSE. If TRUE, will not search for optimized
rds files to load created from ORFik::makeTxdbFromGenome(..., optimize = TRUE). The
optimized files are ~ 100x faster to load for human genome.}

\item{envir}{Which environment to save to, default: .GlobalEnv}
}
\value{
invisible(NULL) (regions saved in envir)
}
\description{
By default loads all parts to .GlobalEnv (global environemnt)
Useful to not spend time on finding the functions to load regions.
}
\examples{
# Load all mrna regions to Global environment
gtf <- system.file("extdata", "hg19_knownGene_sample.sqlite",
                        package = "GenomicFeatures")
loadRegions(gtf, parts = c("mrna", "leaders", "cds", "trailers"))
}
