% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shift_footprints_helpers.R
\name{shifts_load}
\alias{shifts_load}
\title{Load the shifts from experiment}
\usage{
shifts_load(
  df,
  path = file.path(libFolder(df), "pshifted", "shifting_table.rds")
)
}
\arguments{
\item{df}{an ORFik \code{\link{experiment}}}

\item{path}{path, default file.path(libFolder(df), "pshifted", "shifting_table.rds").
Path to .rds file containing the shifts as a list,
one list element per shifted bam file.}
}
\value{
a list of the shifts, one list element per shifted bam file.
}
\description{
When you p-shift using the function shiftFootprintsByExperiment,
you will get a list of shifts per library. To automatically load them, you
can use this function. Defaults to loading pshifts, if you made a-sites or
e-sites, change the path argument to ashifted/eshifted folder instead.
}
\examples{
df <- ORFik.template.experiment()
# subset on Ribo-seq
df <- df[df$libtype == "RFP",][1,]
#shiftFootprintsByExperiment(df)
#shifts_load(df)
}
\seealso{
Other pshifting: 
\code{\link{changePointAnalysis}()},
\code{\link{detectRibosomeShifts}()},
\code{\link{shiftFootprints}()},
\code{\link{shiftFootprintsByExperiment}()},
\code{\link{shiftPlots}()},
\code{\link{shifts_save}()}
}
\concept{pshifting}
