% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Dif_expression_plots.R
\name{DTEG.plot}
\alias{DTEG.plot}
\title{Plot DTEG result}
\usage{
DTEG.plot(
  dt,
  output.dir = NULL,
  p.value.label = ifelse(!is.null(attr(dt, "p.value")), attr(dt, "p.value"), 0.05),
  plot.title = "",
  plot.ext = ".pdf",
  width = 6,
  height = 6,
  dpi = 300,
  dot.size = 0.4,
  xlim = "bidir.max",
  ylim = "bidir.max",
  relative.name = paste0("DTEG_plot", plot.ext),
  plot_to_console = TRUE
)
}
\arguments{
\item{dt}{a data.table with the results from \code{\link{DTEG.analysis}}}

\item{output.dir}{a character path, default NULL(no save), or a directory
to save to a file. Relative name of file, specified by 'relative.name' argument.}

\item{p.value.label}{a numeric, default
ifelse(!is.null(attr(dt, "p.value")), attr(dt, "p.value"), 0.05)
Interval (0,1), use"" to not show.
What p-value used for the analysis? Will be shown as a caption.}

\item{plot.title}{title for plots, usually name of experiment etc}

\item{plot.ext}{character, default: ".pdf". Alternatives: ".png" or ".jpg".
Multiple values allowed, if so will save file in each format specified.}

\item{width}{numeric, default 6 (in inches)}

\item{height}{numeric, default 6 (in inches)}

\item{dpi}{numeric, default 300.}

\item{dot.size}{numeric, default 0.4, size of point dots in plot.}

\item{xlim}{numeric vector or character preset, default: "bidir.max"
(Equal in both + / - direction, using max value + 0.5 of rna column in dt).
If you want ggplot to decide limit, set to "auto".
For numeric vector, specify min and max x limit: like c(-5, 5)}

\item{ylim}{numeric vector or character preset, default: "bidir.max"
(Equal in both + / - direction, using max value + 0.5 of rfp column in dt).
If you want ggplot to decide limit, set to "auto".
For numeric vector, specify min and max y limit: like c(-10, 10)}

\item{relative.name}{character, Default: \code{paste0("DTEG_plot", plot.ext)}
Relative name of file to be saved in folder specified in output.dir.
Change to .pdf if you want pdf file instead of png.
Multiple values allowed, if so will save file in each format specified.}

\item{plot_to_console}{logical, default TRUE. Plot to console before returning,
set to FALSE to save some run time.}
}
\value{
a ggplot object, will facet_wrap if length(unique(dt$contrasts)) > 1
}
\description{
For explanation of plot catagories, see \code{\link{DTEG.analysis}}
}
\examples{
df <- ORFik.template.experiment()
df.rfp <- df[df$libtype == "RFP",]
df.rna <- df[df$libtype == "RNA",]
#dt <- DTEG.analysis(df.rfp, df.rna)
#Default scaling
#DTEG.plot(dt)
#Manual scaling
#DTEG.plot(dt, xlim = c(-2, 2), ylim = c(-2, 2))
}
\seealso{
Other DifferentialExpression: 
\code{\link{DEG.plot.static}()},
\code{\link{DEG_model}()},
\code{\link{DTEG.analysis}()},
\code{\link{te.table}()},
\code{\link{te_rna.plot}()}
}
\concept{DifferentialExpression}
