% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ORFik.R
\docType{package}
\name{ORFik-package}
\alias{ORFik}
\alias{ORFik-package}
\title{ORFik for analysis of open reading frames.}
\description{
Main goals:
\enumerate{
\item Finding Open Reading Frames (very fast) in the genome of interest or
 on the set of transcripts/sequences.
\item Utilities for metaplots of RiboSeq coverage over gene START and STOP
codons allowing to spot the shift.
\item Shifting functions for the RiboSeq data.
\item Finding new Transcription Start Sites with the use of CageSeq data.
\item Various measurements of gene identity e.g. FLOSS, coverage, ORFscore,
entropy that are recreated based on many scientific publications.
\item Utility functions to extend GenomicRanges for faster grouping,
splitting, tiling etc.
}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/Roleren/ORFik}
  \item Report bugs at \url{https://github.com/Roleren/ORFik/issues}
}

}
\author{
\strong{Maintainer}: Haakon Tjeldnes \email{hauken_heyken@hotmail.com} (\href{https://orcid.org/0000-0002-2077-747X}{ORCID}) [data contributor]

Authors:
\itemize{
  \item Kornel Labun \email{kornellabun@gmail.com} [copyright holder]
}

Other contributors:
\itemize{
  \item Michal Swirski \email{michal.swirski@uw.edu.pl} [contributor]
  \item Katarzyna Chyzynska \email{katchyz@gmail.com} [contributor, data contributor]
  \item Yamila Torres Cleuren \email{yamilatorrescleuren@gmail.com} [contributor, thesis advisor]
  \item Eivind Valen \email{eivind.valen@gmail.com} [thesis advisor, funder]
}

}
