% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report_helpers.R
\name{QC_count_tables}
\alias{QC_count_tables}
\title{Create count table info for QC report}
\usage{
QC_count_tables(
  df,
  out.dir,
  type = "ofst",
  use_simplified_reads = TRUE,
  force = TRUE,
  forceRemake = FALSE,
  library.names = bamVarName(df),
  BPPARAM = bpparam()
)
}
\arguments{
\item{df}{an ORFik \code{\link{experiment}}}

\item{out.dir}{character, output directory, default:
\code{resFolder(df)}.
Will make a folder within this called "QC_STATS" with all results in this directory.
Warning: If you assign not default path, you will have a hazzle to load files later.
Much easier to load count tables, statistics, ++ later with default. Update
resFolder of df instead if needed.}

\item{type}{a character(default: "default"), load files in experiment
or some precomputed variant, like "ofst" or "pshifted".
These are made with ORFik:::convertLibs(),
shiftFootprintsByExperiment(), etc.
Can also be custom user made folders inside the experiments bam folder.
It acts in a recursive manner with priority: If you state "pshifted",
but it does not exist, it checks "ofst". If no .ofst files, it uses
"default", which always must exists.\cr Presets are (folder is relative
to default lib folder, some types fall back to other formats if folder does not exist):\cr
- "default": load the original files for experiment, usually bam.\cr
- "ofst": loads ofst files from the ofst folder, relative to lib folder (falls back to default)\cr
- "pshifted": loads ofst, wig or bigwig from pshifted folder (falls back to ofst, then default)\cr
- "cov": Load covRle objects from cov_RLE folder (fail if not found)\cr
- "covl": Load covRleList objects, from cov_RLE_List folder (fail if not found)\cr
- "bed": Load bed files, from bed folder (falls back to default)\cr
- Other formats must be loaded directly with fimport}

\item{use_simplified_reads}{logical, default TRUE. For count tables
and coverage plots a speed up for GAlignments is to use 5' ends only. This
will lose some detail for splice sites, but is usually irrelevant. Note: If
reads are precollapsed GRanges, set to FALSE to avoid recollapsing.}

\item{force}{logical, default TRUE If TRUE, reload library files even if
matching named variables are found in environment used by experiment
 (see \code{\link{envExp}}) A simple way to make
sure correct libraries are always loaded. FALSE is faster if data
is loaded correctly already.}

\item{forceRemake}{logical, default FALSE. If TRUE, will not look for existing file count table files.}

\item{library.names}{character vector, names of libraries, default:
name_decider(df, naming)}

\item{BPPARAM}{how many cores/threads to use? default: bpparam().
To see number of threads used, do \code{bpparam()$workers}.
You can also add a time remaining bar, for a more detailed pipeline.}
}
\value{
a data.table of the count info
}
\description{
The better the annotation / gtf used, the more results you get.
}
\keyword{internal}
