% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report.R
\name{QCplots}
\alias{QCplots}
\title{Correlation and coverage plots for ORFikQC}
\usage{
QCplots(
  df,
  region = "mrna",
  stats_folder = QCfolder(df),
  plot.ext = ".pdf",
  complex.correlation.plots = TRUE,
  library.names = bamVarName(df),
  force = TRUE,
  windowSize = 100,
  BPPARAM = bpparam()
)
}
\arguments{
\item{df}{an ORFik \code{\link{experiment}}}

\item{region}{a character (default: mrna), make raw count matrices of
whole mrnas or one of (leaders, cds, trailers)}

\item{stats_folder}{directory to save, default:
\code{QCfolder(df)}}

\item{plot.ext}{character, default: ".pdf". Alternatives: ".png" or ".jpg".}

\item{complex.correlation.plots}{logical, default TRUE. Add in addition
to simple correlation plot two computationally heavy dots + correlation plots.
Useful for deeper analysis, but takes longer time to run, especially on low-quality
gpu computers. Set to FALSE to skip these.}

\item{library.names}{character vector, names of libraries, default:
name_decider(df, naming)}

\item{force}{logical, default TRUE If TRUE, reload library files even if
matching named variables are found in environment used by experiment
 (see \code{\link{envExp}}) A simple way to make
sure correct libraries are always loaded. FALSE is faster if data
is loaded correctly already.}

\item{windowSize}{size of binned windows, minimum of 'wanted_window_size' and
minimum of ranges given. Will inform you if windowSize is < wanted_window_size.}

\item{BPPARAM}{how many cores/threads to use? default: bpparam()}
}
\value{
invisible(NULL) (objects stored to disc)
}
\description{
Correlation plots default to mRNA covering reads.
Meta plots defaults to leader, cds, trailer.\cr
Output will be stored in same folder as the
libraries in df.\cr
Correlation plots will be fpkm correlation and
log2(fpkm + 1) correlation between samples.
}
\details{
Is part of \code{\link{QCreport}}
}
\seealso{
Other QC report: 
\code{\link{QCreport}()},
\code{\link{QCstats}()}
}
\concept{QC report}
\keyword{internal}
