% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gr_positions.R
\name{assignLastExonsStopSite}
\alias{assignLastExonsStopSite}
\title{Reassign the stop positions of the last exons per group}
\usage{
assignLastExonsStopSite(
  grl,
  newStops,
  is.circular = all(isCircular(grl) \%in\% TRUE)
)
}
\arguments{
\item{grl}{a \code{\link{GRangesList}} object}

\item{newStops}{an integer vector of same length as grl,
with new start values (absolute coordinates, not relative)}

\item{is.circular}{logical, default FALSE if not any is: all(isCircular(grl) %in% TRUE).
Where grl is the ranges checked. If TRUE, allow ranges to extend
below position 1 on chromosome. Since circular genomes can have negative coordinates.}
}
\value{
the same GRangesList with new stop sites
}
\description{
Per group in GRangesList, assign the most downstream site.
}
\details{
make sure your grl is sorted, since stop of "-" strand objects
should be the min start in group, use ORFik:::sortPerGroup(grl) to get
sorted grl.
}
\seealso{
Other GRanges: 
\code{\link{assignFirstExonsStartSite}()},
\code{\link{downstreamFromPerGroup}()},
\code{\link{downstreamOfPerGroup}()},
\code{\link{upstreamFromPerGroup}()},
\code{\link{upstreamOfPerGroup}()}
}
\concept{GRanges}
\keyword{internal}
