% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coverage_filters.R
\name{filterExtremePeakGenes}
\alias{filterExtremePeakGenes}
\title{Filter out transcript by a median filter}
\usage{
filterExtremePeakGenes(
  tx,
  reads,
  upstream = NULL,
  downstream = NULL,
  multiplier = "0.99",
  min_cutoff = "0.999",
  pre_filter_minimum = 0,
  average = "median"
)
}
\arguments{
\item{tx}{a GRangesList}

\item{reads}{a \code{\link{GAlignments}}, \code{\link{GRanges}}, or
precomputed coverage as \code{\link{covRle}} (one for each strand) of
RiboSeq, RnaSeq etc.\cr Weigths for scoring is default the 'score'
column in 'reads'. Can also be random access paths to bigWig or fstwig file.
Do not use random access for more than a few genes, then loading the entire files
is usually better. File streaming is still in beta, so use with care!}

\item{upstream}{numeric or NULL, default NULL.
if you want window of tx, instead of whole, specify how
much upstream from start of tx, 10 is include 10 bases before start}

\item{downstream}{numeric or NULL, default NULL.
if you want window of tx, instead of whole, specify how
much downstream from start of tx, 10 is go 10 bases into tx from start.}

\item{multiplier}{a character or numeric, default "0.99",
either a quantile if input is string[0-1],
like "0.99", or numeric value if input is numeric.
How much bigger than median / mean counts per gene,
must a value be to be defined as extreme ?}

\item{min_cutoff}{a character or numeric, default "0.999",
either a quantile if input is string[0-1],
like "0.999", or numeric value if input is numeric. Lowest allowed value}

\item{pre_filter_minimum}{numeric, default 0. If value is x,
will remove all positions in all genes with coverage < x,
before median filter is applied. Set to 1 to remove all 0 positions.}

\item{average}{character, default "median". Alternative: "mean".
How to scale the multiplier argument, from median or mean of gene coverage.}
}
\value{
GRangesList (filtered)
}
\description{
For removing very extreme peaks in coverage plots, use high quantiles, like
99. Used to make your plots look better, by removing extreme peaks.
}
