% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/txdbHelpers.R
\name{optimizedTranscriptLengths}
\alias{optimizedTranscriptLengths}
\title{Load length and names of all transcripts}
\usage{
optimizedTranscriptLengths(
  txdb,
  with.utr5_len = TRUE,
  with.utr3_len = TRUE,
  create.fst.version = FALSE,
  optimized_path = optimized_txdb_path(txdb, stop.error = FALSE)
)
}
\arguments{
\item{txdb}{a TxDb object, ORFik experiment object or a path to one of:
(.gtf ,.gff, .gff2, .gff2, .db or .sqlite),
Only in the loadRegion function: if it is a GRangesList, it will return it self.}

\item{with.utr5_len}{logical TRUE, include length of 5' UTRs,
ignored if .fst exists}

\item{with.utr3_len}{logical TRUE, include length of 3' UTRs,
ignored if .fst exists}

\item{create.fst.version}{logical, FALSE. If TRUE, creates a .fst version
of the transcript length table (if it not already exists),
reducing load time from ~ 15 seconds to
~ 0.01 second next time you run filterTranscripts with this txdb object.
The file is stored in the
same folder as the genome this txdb is created from, with the name:\cr
\code{paste0(ORFik:::remove.file_ext(metadata(txdb)[3,2]), "_",
       gsub(" \\(.*| |:", "", metadata(txdb)[metadata(txdb)[,1] ==
        "Creation time",2]), "_txLengths.fst")}\cr
Some error checks are done to see this is a valid location, if the txdb
data source is a repository like UCSC and not a local folder, it will not
be made.}

\item{optimized_path}{character, path to optimized txdb objects,
default: optimized_txdb_path(txdb, stop.error = FALSE). If no existing file,
will be slower and load lengths through \code{\link{transcriptLengths}}.}
}
\value{
a data.table of loaded lengths 8 columns,
1 row per transcript isoform.
}
\description{
A speedup wrapper around \code{\link{transcriptLengths}},
default load time of lengths is ~ 15 seconds, if ORFik fst
optimized lengths object has been made, load that file instead:
load time reduced to ~ 0.1 second.
}
\examples{
dt <- optimizedTranscriptLengths(ORFik.template.experiment())
dt
dt[cds_len > 0,] # All mRNA
}
