% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report_plots.R
\name{pcaExperiment}
\alias{pcaExperiment}
\title{Simple PCA analysis from ORFik experiment}
\usage{
pcaExperiment(
  df,
  output.dir = NULL,
  table = countTable(df, "cds", type = "fpkm"),
  title = "PCA analysis by CDS fpkm",
  subtitle = paste("Numer of genes/regions:", nrow(table)),
  plot.ext = ".pdf",
  return.data = FALSE,
  color.by.group = TRUE,
  PCA_X = "PC1",
  PCA_Y = "PC2"
)
}
\arguments{
\item{df}{an ORFik \code{\link{experiment}}}

\item{output.dir}{default NULL, else character path to directory.
File saved as "PCAplot_(experiment name)(plot.ext)"}

\item{table}{data.table, e.g. countTable(df, "cds", type = "fpkm"),
a data.table of counts per column (default normalized fpkm values).}

\item{title}{character, default "CDS fpkm".}

\item{subtitle}{character, default: \code{paste("Numer of genes:", nrow(table))}}

\item{plot.ext}{character, default: ".pdf". Alternatives: ".png" or ".jpg".}

\item{return.data}{logical, default FALSE. Return data instead of plot}

\item{color.by.group}{logical, default TRUE. Colors in PCA plot represent
unique library groups, if FALSE. Color each sample in seperate color
(harder to distinguish for > 10 samples)}

\item{PCA_X}{name of priniciple component to use for x axis: valid options: PC1-PC6}

\item{PCA_Y}{name of priniciple component to use for y axis: valid options: PC1-PC6}
}
\value{
ggplot if return.data is false, data.table of PCAs if return.data is TRUE,
if data has < 3 samples, returns (invisible(NULL))
}
\description{
Detect outlier libraries with PCA analysis.
Will output PCA plot of PCA component 1 (x-axis) vs
PCA component 2 (y-axis) for each library (colored by library),
shape by replicate. Will be extended to allow batch correction
in the future.
}
\examples{
df <- ORFik.template.experiment()
# Select only Ribo-seq and RNA-seq
pcaExperiment(df[df$libtype \%in\% c("RNA", "RFP"),])
}
