% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feature_helpers.R
\name{startRegionString}
\alias{startRegionString}
\title{Get start region as DNA-strings per GRanges group}
\usage{
startRegionString(grl, tx, faFile, upstream = 20, downstream = 20)
}
\arguments{
\item{grl}{a \code{\link{GRangesList}} of ranges to find regions in.}

\item{tx}{a \code{\link{GRangesList}} of transcripts or (container region),
names of tx must contain all gr names. The names of gr can also be the
ORFik orf names. that is "txName_id".}

\item{faFile}{\code{\link{FaFile}}, BSgenome, fasta/index file path or an
ORFik \code{\link{experiment}}. This file is usually used to find the
transcript sequences from some GRangesList.}

\item{upstream}{an integer, default (0), relative region to get
upstream end from. (0 means start site, +1 is one upstream, -1 is one downstream)}

\item{downstream}{an integer, default (0), relative region to get
downstream end from (0 means start site, +1 is one downstream, -1 is one upstream)}
}
\value{
a character vector of start regions
}
\description{
One window per start site, if upstream and downstream are both 0, then
only the startsite is returned.
}
