% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/patternDistri.R
\name{patternDistri}
\alias{patternDistri}
\title{Probabilities of all upregulation patterns}
\usage{
patternDistri(ppnull)
}
\arguments{
\item{ppnull}{a list returned by \code{\link{postProbNull}} or
\code{\link{OVESEGtest}}.}
}
\value{
a data frame object containing all possible upregulation patterns
and corresponding probabilities.
}
\description{
This function estimates probabilities of all kinds of upregulation patterns
among subtypes.
}
\details{
The probability of each upregulation pattern is calculated by
accumulating and normalizing genewise posterior probability of null
hypotheses and of alternative hypotheses.
}
\examples{
data(RocheBT)
ppnull <- postProbNull(RocheBT$y, RocheBT$group, alpha='moderated')
pd<- patternDistri(ppnull)
}
