% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/keggrest.R
\name{kegg_query}
\alias{kegg_query}
\title{Compile a query for the KEGG REST API}
\usage{
kegg_query(operation, ...)
}
\arguments{
\item{operation}{Character: one of the KEGG REST API operations.}

\item{...}{Arguments for the API operation, as defined in the templates
available by \code{\link{kegg_api_templates}} and in the page
\url{https://www.kegg.jp/kegg/rest/keggapi.html}.}
}
\value{
A list with the following elements: \itemize{
    \item operation - The KEGG API operation.
    \item names - The names of the arguments.
    \item query - The values of the arguments.
    \item error - Error messages.
    \item complete - Whether the query has all mandatory arguments.
}
Raises an error if fails to successfully compile a valid query.
}
\description{
Compile a query for the KEGG REST API
}
\examples{
kegg_query("conv", "compound", "pubchem")

}
