% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oma.R
\name{oma_pairwise_translated}
\alias{oma_pairwise_translated}
\title{Orthologous pairs between two organisms for ID types not supported by OMA}
\usage{
oma_pairwise_translated(
  organism_a = "human",
  organism_b = "mouse",
  id_type = "uniprot",
  oma_id_type = "uniprot_entry",
  mappings = c("1:1", "1:m", "n:1", "n:m"),
  only_ids = TRUE
)
}
\arguments{
\item{organism_a}{Name or identifier of an organism.}

\item{organism_b}{Name or identifier of another organism.}

\item{id_type}{The gene or protein identifier to use in the table. For a
list of supported ID types see `omnipathr.env$id_types$oma`. These are
the identifiers that will be translated to gene symbols.}

\item{oma_id_type}{Character: the gene or protein identifier to be queried
from OMA. These IDs will be translated to `id_type`.}

\item{mappings}{Character vector: control ambiguous mappings: \itemize{
    \item{1:1 - unambiguous}
    \item{1:m - one-to-many}
    \item{n:1 - many-to-one}
    \item{n:m - many-to-many}
}}

\item{only_ids}{Logical: include only the two identifier columns, not the
mapping type and the orthology group columns.}
}
\value{
A data frame with orthologous gene pairs.
}
\description{
The Orthologous Matrix (OMA), a resource of orthologous relationships
between genes, doesn't provide gene symbols, the identifier preferred in
many bioinformatics pipelines. Hence this function wraps
\code{\link{oma_pairwise}} by translating the identifiers used in OMA to
gene symbols. Items that can not be translated to `id_type` (but present
in the data with their internal OMA IDs) will be removed. Then,
in this function we translate the identifiers to the desired ID type.
}
\examples{
oma_pairwise_translated("human", "mouse")

}
