% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evidences.R
\name{only_from}
\alias{only_from}
\title{Recreate interaction data frame based on certain datasets and resources}
\usage{
only_from(
  data,
  datasets = NULL,
  resources = NULL,
  exclude = NULL,
  .keep = FALSE
)
}
\arguments{
\item{data}{An interaction data frame from the OmniPath web service with
evidences column.}

\item{datasets}{Character: a vector of dataset labels. Only evidences from
these datasets will be used.}

\item{resources}{Character: a vector of resource labels. Only evidences
from these resources will be used.}

\item{exclude}{Character vector of resource names to be excluded.}

\item{.keep}{Logical: keep the "evidences" column.}
}
\value{
A copy of the interaction data frame restricted to the given
    datasets and resources.
}
\description{
Recreate interaction data frame based on certain datasets and resources
}
\details{
The OmniPath interactions database fully integrates all attributes from all
resources for each interaction. This comes with the advantage that
interaction data frames are ready for use in most of the applications;
however, it makes it impossible to know which of the resources and
references support the direction or effect sign of the interaction. This
information can be recovered from the "evidences" column. The "evidences"
column preserves all the details about interaction provenances. In cases
when you want to use a faithful copy of a certain resource or dataset, this
function will help you do so. Still, in most of the applications the best is
to use the interaction data as it is returned by the web service.

\strong{Note:} This function is automatically applied if the
`strict_evidences` argument is passed to any function querying interactions
(e.g. \code{\link{omnipath-interactions}}).
}
\examples{
\dontrun{
ci <- collectri(evidences = TRUE)
ci <- only_from(ci, datasets = 'collectri')
}

}
\seealso{
\itemize{
    \item{\code{\link{omnipath-interactions}}}
    \item{\code{\link{filter_evidences}}}
    \item{\code{\link{unnest_evidences}}}
    \item{\code{\link{from_evidences}}}
}
}
