% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chalmers_gem.R
\name{chalmers_gem_raw}
\alias{chalmers_gem_raw}
\title{GEM matlab file from Chalmers Sysbio (Wang et al., 2021)}
\usage{
chalmers_gem_raw(organism = "Human")
}
\arguments{
\item{organism}{Character or integer: name or identifier of the organism.
Supported taxons are 9606 (Homo sapiens), 10090 (Mus musculus),
10116 (Rattus norvegicu), 7955 (Danio rerio), 7227 (Drosophila
melanogaster) and 6239 (Caenorhabditis elegans).}
}
\value{
Matlab object containing the GEM.
}
\description{
Downloads and imports the matlab file containing the genome scale metabolic
models created by Chalmers SysBio.
}
\details{
The Matlab object is parsed into a nested list containing a number
  of vectors and two sparse matrices. The top level contains a single
  element under the name "ihuman" for human; under this key there is an
  array of 31 elements. These elements are labeled by the row names of the
  array.
}
\examples{
chalmers_gem_raw()

}
\references{
Wang H, Robinson JL, Kocabas P, Gustafsson J, Anton M, Cholley
  PE, Huang S, Gobom J, Svensson T, Uhlen M, Zetterberg H, Nielsen J.
  Genome-scale metabolic network reconstruction of model animals as a
  platform for translational research. Proc Natl Acad Sci U S A. 2021 Jul
  27;118(30):e2102344118. doi: \doi{10.1073/pnas.2102344118}.
}
\seealso{
\itemize{
    \item{\code{\link{chalmers_gem_network}}}
    \item{\code{\link{chalmers_gem_reactions}}}
    \item{\code{\link{chalmers_gem}}}
    \item{\code{\link{chalmers_gem_reactions}}}
    \item{\code{\link{chalmers_gem_id_mapping_table}}}
    \item{\code{\link{cosmos_pkn}}}
}
}
