% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxonomy.R
\name{ncbi_taxid}
\alias{ncbi_taxid}
\title{NCBI Taxonomy IDs of organisms}
\usage{
ncbi_taxid(name)
}
\arguments{
\item{name}{Vector with any kind of organism name or identifier, can be
also mixed type.}
}
\value{
Integer vector with NCBI Taxonomy IDs, NA if a name
    in the input could not be found.
}
\description{
NCBI Taxonomy IDs of organisms
}
\examples{
ncbi_taxid(c("Homo sapiens", "cat", "dog"))
# [1] 9606 9685 9615
ncbi_taxid(c(9606, "cat", "doggy"))
# [1] 9606 9685   NA

}
\seealso{
\itemize{
    \item{\code{\link{latin_name}}}
    \item{\code{\link{common_name}}}
    \item{\code{\link{ensembl_name}}}
}
}
