% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nichenet.R
\name{nichenet_gr_network_harmonizome}
\alias{nichenet_gr_network_harmonizome}
\title{NicheNet gene regulatory network from Harmonizome}
\usage{
nichenet_gr_network_harmonizome(
  datasets = c("cheappi", "encodetfppi", "jasparpwm", "transfac", "transfacpwm",
    "motifmap", "geotf", "geokinase", "geogene"),
  ...
)
}
\arguments{
\item{datasets}{The datasets to use. For possible values please refer to
default value and the Harmonizome webpage.}

\item{...}{Ignored.}
}
\value{
Data frame with gene regulatory interactions in NicheNet format.
}
\description{
Builds gene regulatory network prior knowledge for NicheNet using
Harmonizome
}
\examples{
# use only JASPAR and TRANSFAC:
hz_gr_network <- nichenet_gr_network_harmonizome(
    datasets = c('jasparpwm', 'transfac', 'transfacpwm')
)

}
\seealso{
\itemize{
    \item{\code{\link{nichenet_gr_network}}}
    \item{\code{\link{harmonizome_download}}}
}
}
