% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nichenet.R
\name{nichenet_lr_network_ramilowski}
\alias{nichenet_lr_network_ramilowski}
\title{Ligand-receptor network from Ramilowski 2015}
\usage{
nichenet_lr_network_ramilowski(
  evidences = c("literature supported", "putative")
)
}
\arguments{
\item{evidences}{Character: evidence types, "literature supported",
"putative" or both.}
}
\value{
Data frame with ligand-receptor interactions in NicheNet format.
}
\description{
Downloads ligand-receptor interactions from Supplementary Table 2 of the
paper 'A draft network of ligand–receptor-mediated multicellular signalling
in human' (Ramilowski et al. 2015,
\url{https://www.nature.com/articles/ncomms8866}). It converts the
downloaded table to a format suitable for NicheNet.
}
\examples{
# use only the literature supported data:
rami_lr_network <- nichenet_lr_network_ramilowski(
    evidences = 'literature supported'
)

}
\seealso{
\itemize{
    \item{\code{\link{nichenet_lr_network}}}
    \item{\code{\link{ramilowski_download}}}
}
}
