% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nichenet.R
\name{nichenet_networks}
\alias{nichenet_networks}
\title{Builds NicheNet network prior knowledge}
\usage{
nichenet_networks(
  signaling_network = list(),
  lr_network = list(),
  gr_network = list(),
  only_omnipath = FALSE,
  small = FALSE,
  tiny = FALSE,
  quality_filter_param = list()
)
}
\arguments{
\item{signaling_network}{A list of parameters for building the signaling
network, passed to \code{\link{nichenet_signaling_network}}}

\item{lr_network}{A list of parameters for building the ligand-receptor
network, passed to \code{\link{nichenet_lr_network}}}

\item{gr_network}{A list of parameters for building the gene regulatory
network, passed to \code{\link{nichenet_gr_network}}}

\item{only_omnipath}{Logical: a shortcut to use only OmniPath as network
resource.}

\item{small}{Logical: build a small network for testing purposes, using
only OmniPath data. It is also a high quality network, it is
reasonable to try the analysis with this small network.}

\item{tiny}{Logical: build an even smaller network for testing
purposes. As this involves random subsetting, it's not recommended
to use this network for analysis.}

\item{quality_filter_param}{Arguments for \code{
\link{filter_intercell_network}} (quality filtering of the OmniPath
ligand-receptor network). It is recommended to check these parameters
and apply some quality filtering. The defaults already ensure certain
filtering, but you might want more relaxed or stringent options.}
}
\value{
A named list with three network data frames (tibbles): the
    signaling, the ligand-receptor (lr) and the gene regulatory (gr)
    networks.
}
\description{
Builds network knowledge required by NicheNet. For this it calls
a multitude of methods to download and combine data from various
databases according to the settings. The content of the prior knowledge
data is highly customizable, see the documentation of the related
functions.
}
\examples{
\dontrun{
networks <- nichenet_networks()
dplyr::sample_n(networks$gr_network, 10)
# # A tibble: 10 x 4
#    from    to       source               database
#    <chr>   <chr>    <chr>                <chr>
#  1 MAX     ALG3     harmonizome_ENCODE   harmonizome
#  2 MAX     IMPDH1   harmonizome_ENCODE   harmonizome
#  3 SMAD5   LCP1     Remap_5              Remap
#  4 HNF4A   TNFRSF19 harmonizome_CHEA     harmonizome
#  5 SMC3    FAP      harmonizome_ENCODE   harmonizome
#  6 E2F6    HIST1H1B harmonizome_ENCODE   harmonizome
#  7 TFAP2C  MAT2B    harmonizome_ENCODE   harmonizome
#  8 USF1    TBX4     harmonizome_TRANSFAC harmonizome
#  9 MIR133B FETUB    harmonizome_TRANSFAC harmonizome
# 10 SP4     HNRNPH2  harmonizome_ENCODE   harmonizome
}

# use only OmniPath:
omnipath_networks <- nichenet_networks(only_omnipath = TRUE)

}
\seealso{
\itemize{
    \item{\code{\link{nichenet_signaling_network}}}
    \item{\code{\link{nichenet_lr_network}}}
    \item{\code{\link{nichenet_gr_network}}}
}
}
