% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enz_sub.R
\name{signed_ptms}
\alias{signed_ptms}
\alias{get_signed_ptms}
\title{Causal effect enzyme-PTM interactions}
\usage{
signed_ptms(
  enzsub = enzyme_substrate(),
  interactions = omnipath_interactions()
)
}
\arguments{
\item{enzsub}{Enzyme-substrate data frame generated by
\code{\link{enzyme_substrate}}}

\item{interactions}{interaction data frame generated by an OmniPath
interactions query: \code{\link{omnipath-interactions}}}
}
\value{
Data frame of enzyme-substrate relationships with is_inhibition
    and is_stimulation columns.
}
\description{
Enzyme-substrate data does not contain sign (activation/inhibition), we
generate this information based on the interaction network.
}
\examples{
enzsub <- enzyme_substrate(resources = c("PhosphoSite", "SIGNOR"))
interactions <- omnipath_interactions()
enzsub <- signed_ptms(enzsub, interactions)

}
\seealso{
\itemize{
    \item{\code{\link{enzyme_substrate}}}
    \item{\code{\link{omnipath-interactions}}}
}
}
