% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/id_mapping.R
\name{uniprot_id_mapping_table}
\alias{uniprot_id_mapping_table}
\title{ID translation data from UniProt ID Mapping}
\usage{
uniprot_id_mapping_table(identifiers, from, to, chunk_size = NULL)
}
\arguments{
\item{identifiers}{Character vector of identifiers}

\item{from}{Character or symbol: type of the identifiers provided.
See Details for possible values.}

\item{to}{Character or symbol: identifier type to be retrieved from
UniProt. See Details for possible values.}

\item{chunk_size}{Integer: query the identifiers in chunks of this size.
If you are experiencing download failures, try lower values.}
}
\value{
A data frame (tibble) with columns `From` and `To`, the
    identifiers provided and the corresponding target IDs, respectively.
}
\description{
Retrieves an identifier translation table from the UniProt ID Mapping
service (https://www.uniprot.org/help/id_mapping).
}
\details{
This function uses the uploadlists service of UniProt to obtain identifier
translation tables. The possible values for `from` and `to` are the
identifier type abbreviations used in the UniProt API, please refer to
the table here: \code{\link{uniprot_idmapping_id_types}} or
the table of synonyms supported by the current package:
\code{\link{translate_ids}}.
Note: if the number of identifiers is larger than the chunk size the log
message about the cache origin is not guaranteed to be correct (most
of the times it is still correct).
}
\examples{
uniprot_genesymbol <- uniprot_id_mapping_table(
    c('P00533', 'P23771'), uniprot, genesymbol
)
uniprot_genesymbol
# # A tibble: 2 x 2
#   From   To
#   <chr>  <chr>
# 1 P00533 EGFR
# 2 P23771 GATA3

}
\seealso{
\code{\link{translate_ids}}
}
