% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pairadise.R
\name{results}
\alias{results}
\title{Extract results for pairadise analysis}
\usage{
results(pdat, p.adj = "BH", sig.level = 0.01, details = FALSE)
}
\arguments{
\item{pdat}{A PDseDataSet object from pairadise analysis}

\item{p.adj}{The p ajustment method.}

\item{sig.level}{The cutoff of significant results}

\item{details}{Whether to list detailed results.}
}
\value{
The function return a results DataFrame.
\item{testStats}{Vector of test statistics for paired
    analysis.}
\item{p.value}{Vector of pvalues for each
    exon/event.}
\item{p.adj}{The adjusted p values}
If details is TRUE, more detailed parameter estimates for constrained and
unconstrained model will return.
}
\description{
Extract results for pairadise analysis
}
\examples{
data("sample_dataset")
pdat <- PDseDataSetFromMat(sample_dataset)
pdat <- pairadise(pdat)
results(pdat)
}
