% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/randomMethods.R
\name{chooseGavishDonoho}
\alias{chooseGavishDonoho}
\title{Choosing PCs with the Gavish-Donoho method}
\usage{
chooseGavishDonoho(x, .dim = dim(x), var.explained, noise)
}
\arguments{
\item{x}{The data matrix used for the PCA, containing variables in rows and observations in columns.
Ignored if \code{dim} is supplied.}

\item{.dim}{An integer vector containing the dimensions of the data matrix used for PCA.
The first element should contain the number of variables and the second element should contain the number of observations.}

\item{var.explained}{A numeric vector containing the variance explained by successive PCs.
This should be sorted in decreasing order.
Note that this should be the variance explained, NOT the percentage of variance explained!}

\item{noise}{Numeric scalar specifying the variance of the random noise.}
}
\value{
An integer scalar specifying the number of PCs to retain.
The effective limit on the variance explained is returned in the attributes.
}
\description{
Use the Gavish-Donoho method to determine the optimal number of PCs to retain.
}
\details{
Assuming that \code{x} is the sum of some low-rank truth and some i.i.d. random matrix with variance \code{noise},
the Gavish-Donoho method defines a threshold on the singular values that minimizes the reconstruction error from the PCs.
This provides a mathematical definition of the \dQuote{optimal} choice of the number of PCs for a given matrix,
though it depends on both the i.i.d. assumption and an estimate for \code{noise}.
}
\examples{
truth <- matrix(rnorm(1000), nrow=100)
truth <- truth[,sample(ncol(truth), 1000, replace=TRUE)]
obs <- truth + rnorm(length(truth), sd=2)

# Note, we need the variance explained, NOT the percentage
# of variance explained! 
pcs <- pca(obs)
chooseGavishDonoho(obs, var.explained=pcs$sdev^2, noise=4)

}
\seealso{
\code{\link{chooseMarchenkoPastur}}, \code{\link{parallelPCA}} and \code{\link{findElbowPoint}}, 
for other approaches to choosing the number of PCs.
}
\author{
Aaron Lun
}
