% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batch_detection.R
\name{Scatter_Density}
\alias{Scatter_Density}
\title{Principal Component Analysis (PCA) with Density Plots per Component}
\usage{
Scatter_Density(
    object,
    batch = NULL,
    trt = NULL,
    xlim = NULL,
    ylim = NULL,
    color.set = NULL,
    batch.legend.title = "Batch",
    trt.legend.title = "Treatment",
    density.lwd = 0.2,
    title = NULL,
    title.cex = 1.5,
    legend.cex = 0.7,
    legend.title.cex = 0.75
)
}
\arguments{
\item{object}{The object of class PCA.}

\item{batch}{A factor or a class vector for the batch grouping information
(categorical outcome variable).}

\item{trt}{A factor or a class vector for the treatment grouping information
(categorical outcome variable).}

\item{xlim}{A numeric vector of length 2, indicating the x coordinate ranges.}

\item{ylim}{A numeric vector of length 2, indicating the y coordinate ranges.}

\item{color.set}{A vector of character, indicating the set of colors to use.
The colors are represented by hexadecimal color code.}

\item{batch.legend.title}{Character, the legend title of batches.}

\item{trt.legend.title}{Character, the legend title of treatments.}

\item{density.lwd}{Numeric, the thickness of density lines.}

\item{title}{Character, the plot title.}

\item{title.cex}{Numeric, the size of plot title.}

\item{legend.cex}{Numeric, the size of legends.}

\item{legend.title.cex}{Numeric, the size of legend title.}
}
\value{
None.
}
\description{
This function draws a PCA sample plot with density plots per
principal component.
}
\examples{
# The first example
library(mixOmics) # for function pca()
library(TreeSummarizedExperiment) # for functions assays(),rowData()
data('AD_data')
# centered log ratio transformed data
ad.clr <- assays(AD_data$EgData)$Clr_value
ad.pca.before <- pca(ad.clr, ncomp = 3, scale = TRUE)
ad.batch <- rowData(AD_data$EgData)$Y.bat # batch information
ad.trt <- rowData(AD_data$EgData)$Y.trt # treatment information
names(ad.batch) <- names(ad.trt) <- rownames(AD_data$EgData)
Scatter_Density(object = ad.pca.before, batch = ad.batch, trt = ad.trt)

# The second example
colorlist <- rainbow(10)
Scatter_Density(object = ad.pca.before, batch = ad.batch, trt = ad.trt,
                color.set = colorlist)

}
\seealso{
\code{\link{box_plot}}, \code{\link{density_plot}},
\code{\link{alignment_score}} and \code{\link{partVar_plot}} as the other
methods for batch effect detection and batch effect removal assessment.
}
\author{
Yiwen Wang, Kim-Anh Lê Cao
}
