% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrix2OP.R
\name{matrix2OP}
\alias{matrix2OP}
\title{Generate a occurrence plot from a matrix}
\usage{
matrix2OP(input, x = NULL, y = NULL)
}
\arguments{
\item{input}{A matrix containing the data to be visualized in the occurrence plot}

\item{x}{A character vector specifying the columns to highlight in the occurrence plot}

\item{y}{A character vector specifying the rows to highlight in the occurrence plot}
}
\value{
A occurrence plot with highlighted specified rows and columns
}
\description{
This function generates a occurrence plot using the `plotly` package.
The occurrence plot highlights specific rows and columns provided by the user, while the rest of the matrix is dimmed.
The function also adds grid lines to the occurrence plot for better readability.
}
\examples{
# Create a sample matrix with row and column names
mat <- matrix(c(1, 0, 1, 0), 2, 2)
colnames(mat) <- c("Col1", "Col2")
rownames(mat) <- c("Row1", "Row2")
occurrence_plot <- matrix2OP(input = mat, x = "Col1", y = "Row1")
occurrence_plot
}
