% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrix2SquareOP.R
\name{matrix2SquareOP}
\alias{matrix2SquareOP}
\title{Generate a square occurrence plot from a matrix}
\usage{
matrix2SquareOP(input, x = NULL, y = NULL)
}
\arguments{
\item{input}{A matrix containing the data to be visualized.}

\item{x}{A character vector specifying the columns to highlight.}

\item{y}{A character vector specifying the rows to highlight.}
}
\value{
A plotly heatmap object with a square layout.
}
\description{
This function generates a occurrence plot using `plotly`, ensuring the plot has a
square aspect ratio. It highlights user-specified rows and columns.
}
\examples{
# Create a sample matrix
mat <- matrix(c(1, 0, 1, 0), 2, 2)
colnames(mat) <- c("Col1", "Col2")
rownames(mat) <- c("Row1", "Row2")
square_occurrence_plot <- matrix2SquareOP(input = mat, x = "Col1", y = "Row1")
# To display in an interactive session:
# sq_heatmap
}
