% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readProsite.R
\name{readProsite}
\alias{readProsite}
\title{Convert PROSITE format to a GFF-like Data Frame}
\usage{
readProsite(prosite_input)
}
\arguments{
\item{prosite_input}{Path to the PROSITE scan output file.}
}
\value{
A data frame with columns approximating GFF fields plus additional
  PROSITE-specific information.
}
\description{
This function parses a file from a PROSITE scan (standard output format)
into a data frame. It handles multi-line sequence outputs and extracts
information into a GFF-like structure compatible with rtracklayer imports.
}
\examples{
# Get path to example file
prosite_file <- system.file("extdata", "out_Hb_PROSITE.txt", package = "PMScanR")

if (nzchar(prosite_file) && file.exists(prosite_file)) {
  prosite_data <- readProsite(prosite_file)
  head(prosite_data)
}
}
