% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NormalizationMethods.R
\name{eigenMSNorm}
\alias{eigenMSNorm}
\title{EigenMS Normalization}
\usage{
eigenMSNorm(se, ain = "log2", aout = "EigenMS", on_raw = FALSE)
}
\arguments{
\item{se}{SummarizedExperiment containing all necessary information of the proteomic dataset}

\item{ain}{String which assay should be used as input}

\item{aout}{String which assay should be used to save normalized data}

\item{on_raw}{Boolean specifying whether normalization should be performed on raw or log2-scaled data}
}
\value{
SummarizedExperiment containing the EigenMS normalized data as assay (on log2 scale)
}
\description{
EigenMS fits an analysis of variance model to estimate the effects of the experimental factors on the data using the
knowledge about the experimental design, and then applies singular value decomposition to identify systematic trends 
contributing to significant variation not explained by the experimental factors Log2-scaled data should be used as input (on_raw = FALSE).
}
\examples{
data(tuberculosis_TMT_se)
tuberculosis_TMT_se <- eigenMSNorm(tuberculosis_TMT_se, ain = "log2",
                                    aout = "EigenMS", on_raw = FALSE)

}
