% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getSPS.R
\name{getSPS}
\alias{getSPS}
\title{Generate set of stable phosphoporylated sites}
\usage{
getSPS(phosData, assays, conds, num)
}
\arguments{
\item{phosData}{a list of users' PhosphoExperiment objects from which 
generate SPSs}

\item{assays}{an assay to use for each dataset in phosData}

\item{conds}{a list of vector contains the conditions labels for each sample 
in the phosphoExperiment objects}

\item{num}{the number of identified SPSs, by default is 100}
}
\value{
A vectors of stably phosphorylated sites
}
\description{
Generate set of stable phosphoporylated sites
}
\examples{

library(stringr)

data("phospho_L6_ratio_pe")
data("phospho.liver.Ins.TC.ratio.RUV.pe")
data("phospho.cells.Ins.pe")

ppe1 <- phospho.L6.ratio.pe
ppe2 <- phospho.liver.Ins.TC.ratio.RUV.pe
ppe3 <- phospho.cells.Ins.pe
grp3 = gsub('_[0-9]{1}', '', colnames(ppe3))

cond.list <- list(grp1 = gsub("_.+", "", colnames(ppe1)),
                  grp2 = stringr::str_sub(colnames(ppe2), end=-5),
                  grp3 = grp3)

ppe3 <- selectGrps(ppe3, grps = grp3, 0.5, n=1)
ppe3 <- tImpute(ppe3)

# convert matrix to ratio
FL83B.ratio <- SummarizedExperiment::assay(ppe3,"imputed")[, seq(12)] - 
    rowMeans(
        SummarizedExperiment::assay(ppe3,"imputed")[,grep("FL83B_Control", 
        colnames(ppe3))])
Hepa.ratio <- SummarizedExperiment::assay(ppe3,"imputed")[, seq(13,24,1)] - 
    rowMeans(
        SummarizedExperiment::assay(ppe3, "imputed")[,grep("Hepa1.6_Control", 
        colnames(ppe3))])
SummarizedExperiment::assay(ppe3, "Quantification") <- 
    cbind(FL83B.ratio, Hepa.ratio)

ppe.list <- list(ppe1, ppe2, ppe3)

inhouse_SPSs <- getSPS(ppe.list, conds = cond.list)

}
