% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createProfilePlot.R
\name{addRankDivisionPlot}
\alias{addRankDivisionPlot}
\title{Add taxonomy rank division lines to the heatmap plot}
\usage{
addRankDivisionPlot(profilePlot = NULL, plotDf = NULL,
    taxDB = NULL, workingRank = NULL, superRank = NULL, xAxis = "taxa",
    font = "Arial", groupLabelSize = 14, groupLabelDist = 2,
    groupLabelAngle = 90, refLine = TRUE)
}
\arguments{
\item{profilePlot}{initial (highlighted) profile plot}

\item{plotDf}{dataframe for plotting the heatmap phylogentic profile}

\item{taxDB}{path to taxonomy database (taxonomyMatrix.txt file required!)}

\item{workingRank}{working taxonomy rank (e.g. species)}

\item{superRank}{taxonomy rank for division lines (e.g. superkingdom)}

\item{xAxis}{type of x-axis (either "genes" or "taxa")}

\item{font}{font of text. Default = Arial"}

\item{groupLabelSize}{size of rank labels}

\item{groupLabelDist}{size of the plot area for rank labels}

\item{groupLabelAngle}{angle of rank labels}

\item{refLine}{add vertical line to separate reference taxon}
}
\value{
A profile heatmap plot with highlighted gene and/or taxon of interest
as ggplot object.
}
\description{
Add taxonomy rank division lines to the heatmap plot
}
\examples{
data("finalProcessedProfile", package="PhyloProfile")
plotDf <- dataMainPlot(finalProcessedProfile)
plotParameter <- list(
    "xAxis" = "taxa",
    "geneIdType" = "geneID",
    "var1ID" = "FAS_FW",
    "var2ID"  = "FAS_BW",
    "midVar1" = 0.5,
    "midColorVar1" =  "#FFFFFF",
    "lowColorVar1" =  "#FF8C00",
    "highColorVar1" = "#4682B4",
    "midVar2" = 1,
    "midColorVar2" =  "#FFFFFF",
    "lowColorVar2" = "#CB4C4E",
    "highColorVar2" = "#3E436F",
    "paraColor" = "#07D000",
    "xSize" = 8,
    "ySize" = 8,
    "legendSize" = 8,
    "mainLegend" = "top",
    "dotZoom" = 0,
    "xAngle" = 60,
    "guideline" = 0,
    "colorByGroup" = FALSE,
    "colorByOrthoID" = FALSE
)
profilePlot <- heatmapPlotting(plotDf, plotParameter)
workingRank <- "class"
superRank <- "superkingdom"
addRankDivisionPlot(
    profilePlot, plotDf, NULL, workingRank, superRank, "taxa", font = "sans"
)
}
\seealso{
\code{\link{heatmapPlotting}}, \code{\link{highlightProfilePlot}},
\code{\link{getTaxonomyMatrix}}
}
\author{
Vinh Tran tran@bio.uni-frankfurt.de
}
