% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compareTaxaGroups.R
\name{compareTaxonGroups}
\alias{compareTaxonGroups}
\title{Compare the score distributions between 2 taxon groups}
\usage{
compareTaxonGroups(data, inGroup, useCommonAncestor, variable,
    significanceLevel, taxDB)
}
\arguments{
\item{data}{input phylogenetic profile in long format (see ?mainLongRaw and
?createLongMatrix)}

\item{inGroup}{ID list of in-group taxa (e.g. "ncbi1234")}

\item{useCommonAncestor}{TRUE/FALSE if using all taxa that share the same
common ancestor with the pre-selected in-group as the in-group taxa.
Default = TRUE.}

\item{variable}{name of the variable that need to be compared}

\item{significanceLevel}{significant cutoff for the statistic test (between
0 and 1). Default = 0.05.}

\item{taxDB}{Path to the taxonomy DB files}
}
\value{
list of genes that have a significant difference in the variable
distributions between the in-group and out-group taxa and their corresponding
p-values.
}
\description{
Given the phylogenetic profiles that contains up to 2 additional
variables besides the presence/absence information of the orthologous
proteins. This function will compare the distribution of those variables
between 2 different taxon groups (e.g. parasitic species vs non-parasitic
species), which are defined as in-group and out-group. In-group is identified
by the user. Out-group contains all taxa in the input phylogenetic profiles
that are not part of the in-group.
}
\examples{
data("mainLongRaw", package="PhyloProfile")
data <- mainLongRaw
inGroup <- c("ncbi9606", "ncbi10116")
variable <- colnames(data)[4]
compareTaxonGroups(data, inGroup, TRUE, variable, 0.05)
}
\author{
Vinh Tran (tran@bio.uni-frankfurt.de)
}
